/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolspower.modules.monitor.blocks;

import javax.annotation.Nonnull;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.bindings.GuiValue;
import mcjty.lib.blocks.LogicSlabBlock;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.LogicSupport;
import mcjty.lib.tileentity.TickingTileEntity;
import mcjty.lib.varia.EnergyTools;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolspower.compat.RFToolsPowerTOPDriver;
import mcjty.rftoolspower.modules.monitor.MonitorModule;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.util.LazyOptional;

public class PowerMonitorTileEntity
extends TickingTileEntity {
    private final LogicSupport support = new LogicSupport();
    @Cap(type=CapType.CONTAINER)
    private final LazyOptional<MenuProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Power Monitor").containerSupplier(DefaultContainerProvider.empty(MonitorModule.CONTAINER_POWER_MONITOR, (GenericTileEntity)this)).setupSync((GenericTileEntity)this));
    public static final IntegerProperty LEVEL = IntegerProperty.m_61631_((String)"level", (int)0, (int)5);
    @GuiValue
    private int minimum;
    @GuiValue
    private int maximum;
    private int rflevel = 0;
    private boolean inAlarm = false;
    private int counter = 20;

    public PowerMonitorTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)MonitorModule.TYPE_POWER_MONITOR.get(), pos, state);
    }

    public static LogicSlabBlock createBlock() {
        return new LogicSlabBlock(new BlockBuilder().topDriver((TOPDriver)RFToolsPowerTOPDriver.DRIVER).manualEntry(ManualHelper.create((String)"rftoolspower:powermonitor/powermonitor")).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolspower.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header()}).tileEntitySupplier(PowerMonitorTileEntity::new)){

            protected void m_7926_(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
                super.m_7926_(builder);
                builder.m_61104_(new Property[]{LEVEL});
            }
        };
    }

    public void checkRedstone(Level world, BlockPos pos) {
        this.support.checkRedstone((GenericTileEntity)this, world, pos);
    }

    public int getRedstoneOutput(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
        return this.support.getRedstoneOutput(state, side);
    }

    public int getMinimum() {
        return this.minimum;
    }

    public void setMinimum(int minimum) {
        this.minimum = minimum;
        this.m_6596_();
    }

    public int getMaximum() {
        return this.maximum;
    }

    public void setMaximum(int maximum) {
        this.maximum = maximum;
        this.m_6596_();
    }

    public void setInvalid() {
        this.changeRfLevel(0);
        this.support.setRedstoneState((GenericTileEntity)this, 0);
    }

    protected void tickServer() {
        --this.counter;
        if (this.counter > 0) {
            return;
        }
        this.counter = 20;
        Direction inputSide = LogicSupport.getFacing((BlockState)this.f_58857_.m_8055_(this.m_58899_())).getInputSide();
        BlockPos inputPos = this.m_58899_().m_142300_(inputSide);
        BlockEntity tileEntity = this.f_58857_.m_7702_(inputPos);
        if (!EnergyTools.isEnergyTE((BlockEntity)tileEntity, null)) {
            this.setInvalid();
            return;
        }
        EnergyTools.EnergyLevel energy = EnergyTools.getEnergyLevelMulti((BlockEntity)tileEntity, null);
        long maxEnergy = energy.maxEnergy();
        int ratio = 0;
        boolean alarm = false;
        if (maxEnergy > 0L) {
            long stored = energy.energy();
            ratio = (int)(1L + stored * 5L / maxEnergy);
            if (ratio < 1) {
                ratio = 1;
            } else if (ratio > 5) {
                ratio = 5;
            }
            long percentage = stored * 100L / maxEnergy;
            boolean bl = alarm = percentage >= (long)this.minimum && percentage <= (long)this.maximum;
        }
        if (this.rflevel != ratio) {
            this.changeRfLevel(ratio);
            this.m_6596_();
        }
        if (alarm != this.inAlarm) {
            this.inAlarm = alarm;
            this.support.setRedstoneState((GenericTileEntity)this, this.inAlarm ? 15 : 0);
            this.m_6596_();
        }
    }

    private void changeRfLevel(int newRfLevel) {
        if (newRfLevel != this.rflevel) {
            this.rflevel = newRfLevel;
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.f_58857_.m_8055_(this.f_58858_).m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(this.rflevel)), 11);
            this.m_6596_();
        }
    }

    public void m_142466_(CompoundTag tagCompound) {
        super.m_142466_(tagCompound);
        this.support.setPowerOutput(tagCompound.m_128471_("rs") ? 15 : 0);
        this.inAlarm = tagCompound.m_128471_("inAlarm");
    }

    public void loadInfo(CompoundTag tagCompound) {
        super.loadInfo(tagCompound);
        CompoundTag info = tagCompound.m_128469_("Info");
        this.rflevel = info.m_128451_("rflevel");
        this.minimum = info.m_128445_("minimum");
        this.maximum = info.m_128445_("maximum");
    }

    public void m_183515_(@Nonnull CompoundTag tagCompound) {
        super.m_183515_(tagCompound);
        tagCompound.m_128379_("rs", this.support.getPowerOutput() > 0);
        tagCompound.m_128379_("inAlarm", this.inAlarm);
    }

    public void saveInfo(CompoundTag tagCompound) {
        super.saveInfo(tagCompound);
        CompoundTag info = this.getOrCreateInfo(tagCompound);
        info.m_128405_("rflevel", this.rflevel);
        info.m_128344_("minimum", (byte)this.minimum);
        info.m_128344_("maximum", (byte)this.maximum);
    }
}

